/*
 * Kalter
 * 18:04 02.04.2014
 * (c) Kalter
 * Snake game
 */

import javax.microedition.midlet.MIDlet;
import javax.microedition.lcdui.game.GameCanvas;
import javax.microedition.lcdui.Display;
import javax.microedition.lcdui.Graphics;
import javax.microedition.lcdui.Image;
import javax.microedition.rms.RecordStore;
import javax.microedition.rms.RecordStoreException;
import java.util.Random;
import java.util.Vector;
import java.io.IOException;
import java.lang.String;
import java.lang.System;
import java.lang.Math;
import java.lang.Thread;
import java.lang.Runnable;
import java.lang.InterruptedException;

public final class Core extends MIDlet{

    private MainCanvas mainCanvas=new MainCanvas(this);
    private final Display display=Display.getDisplay(this);

    public Core(){

        try{

            RecordStore recordStore=RecordStore.openRecordStore("Snake",true);
            byte data[]=recordStore.getRecord(1);
            recordStore.closeRecordStore();
            data=null;
            recordStore=null;
        }catch(final RecordStoreException RSE){

            try{

                RecordStore recordStore=RecordStore.openRecordStore(

                        "Snake",
                        true
                    );
                byte data[]=new byte[1];
                data[0]=0;
                recordStore.addRecord(data,0,1);
                recordStore.closeRecordStore();
                data=null;
                recordStore=null;
            }catch(final RecordStoreException RS){

                System.out.println(RS.getMessage());
            }
        }
        Font.init();
        System.out.println("Core loaded");
    }

    public final void pauseApp(){ //приостановленный режим


    }

    public final void destroyApp(boolean b){ //уничтоженный режим

        mainCanvas=null;
        notifyDestroyed();
    }

    public final void startApp(){ //активный режим

        display.setCurrent(mainCanvas);
    }

    /*
     * Kalter
     * 18:10 02.04.2014
     * (c) Kalter
     * Игровой канвас
     */

    private final class MainCanvas extends GameCanvas{

        private final Image BOOFER;
        private final Graphics GRAPHIC;
        private final int SCRX,SCRY;
        private byte screenId=0;
        private Screen screen[]=new Screen[5];

        public MainCanvas(final Core CORE){

            super(false);
            setFullScreenMode(true);
            SCRX=getWidth();
            SCRY=getHeight();
            BOOFER=Image.createImage(SCRX,SCRY);
            GRAPHIC=BOOFER.getGraphics();
            screen[0]=new Splash(SCRX,SCRY,this);
            screen[1]=new Menu(SCRX,SCRY,this,CORE);
            screen[2]=new Game(SCRX,SCRY,this);
            screen[3]=new GameOver(SCRX,SCRY,this);
            screen[4]=new HeightScore(SCRX,SCRY,this);
            Background.init(SCRX,SCRY);
            System.out.println("Core.MainCanvas loaded");
        }

        public final void setScreenId(final byte SCREEN_ID){ //установить экран

            switch(this.screenId){

                case 0:
                    screen[0]=null;
                    break;
            }
            switch(SCREEN_ID){

                case 2:
                    Game game=(Game)screen[2];
                    game.newGame();
                    screen[2]=game;
                    game=null;
                    break;

                case 4:
                    HeightScore heightScore=(HeightScore)screen[4];
                    heightScore.openHeightScore();
                    screen[4]=heightScore;
                    heightScore=null;
                    break;
            }
            this.screenId=SCREEN_ID;
            System.gc();
        }

        public final void paint(final Graphics G){ //перерисовка

            screen[screenId].paint(GRAPHIC);
            G.drawImage(BOOFER,0,0,0);
            repaint();
        }

        public final void keyPressed(final int KEY_CODE){ //нажали кнопку

            screen[screenId].keyPressed(getGameAction(KEY_CODE));
        }

        public final void keyReleased(final int KEY_CODE){ //отпустили кнопку

            screen[screenId].keyReleased(getGameAction(KEY_CODE));
        }

        /*
         * Kalter
         * 18:09 02.04.2014
         * (c) Kalter
         * Для удобной смены экранов
         */

        public abstract class Screen{

            public abstract void paint(final Graphics G); //перерисовка

            public abstract void keyPressed(final int KEY_CODE); //нажали кнопку

            //отпустили кнопку
            public abstract void keyReleased(final int KEY_CODE);
        }

        /*
         * Kalter
         * 18:20 02.04.2014
         * (c) Kalter
         * Сплэш
         */

        private final class Splash extends Screen{

            private final int SCRX,SCRY;
            private final long LAST_TIME=System.currentTimeMillis();
            private final MainCanvas LINK;
            private RImage splash;

            public Splash(final int SCRX,final int SCRY,final MainCanvas LINK){

                this.LINK=LINK;
                this.SCRX=SCRX;
                this.SCRY=SCRY;
                try{

                    splash=new RImage(
                            
                            Image.createImage("/splash.png"),
                            (SCRX-138)/2,
                            (SCRY-48)/2
                        );
                }catch(final IOException IOE){

                    System.out.println(IOE.getMessage());
                }
                System.out.println("Core.MainCanvas.Splash loaded");
            }

            public final void paint(final Graphics G){ //перерисовка

                G.setColor(0x000000);
                G.fillRect(0,0,SCRX,SCRY);
                G.drawImage(

                        splash.getImage(),
                        splash.getPosx(),
                        splash.getPosy(),
                        0
                    );
                if(System.currentTimeMillis()-LAST_TIME>5000)
                    LINK.setScreenId((byte)1);
            }

            public final void keyPressed(final int KEY_CODE){ //нажади кнопку


            }

            //отпустили кнопку
            public final void keyReleased(final int KEY_CODE){


            }
        }

        /*
         * Kalter
         * 18:14 02.04.2014
         * (c) Kalter
         * Главное меню
         */

        public final class Menu extends Screen{

            private final int SCRX,SCRY;
            private final MainCanvas LINK;
            private final Core CORE;
            private byte pos=0;
            private RImage choise[]=new RImage[3];
            private RImage logo;
            private Image noPos,yesPos;

            public Menu(

                    final int SCRX,
                    final int SCRY,
                    final MainCanvas LINK,
                    final Core CORE
                ){

                this.CORE=CORE;
                this.LINK=LINK;
                this.SCRX=SCRX;
                this.SCRY=SCRY;
                try{

                    logo=new RImage(

                            Image.createImage("/logo.png"),
                            (this.SCRX-116)/2,
                            22
                        );
                    for(int i=0;i<choise.length;i++)
                        choise[i]=new RImage(

                                Image.createImage("/choise"+i+".png"),
                                (this.SCRX-116)/2,
                                i*16+60
                            );
                    noPos=Image.createImage("/item.png");
                    int width=noPos.getWidth();
                    int height=noPos.getHeight();
                    int argb[]=new int[width*height];
                    noPos.getRGB(argb,0,width,0,0,width,height);
                    for(int i=0;i<argb.length;i++)
                        argb[i]+=0x101010;
                    yesPos=Image.createRGBImage(argb,width,height,true);
                }catch(final IOException IOE){

                    System.out.println(IOE.getMessage());
                }
                System.out.println("Core.MainCanvas.Menu loaded");
            }

            public final void paint(final Graphics G){ //перерисовка

                Background.paint(G);
                G.drawImage(logo.getImage(),logo.getPosx(),logo.getPosy(),0);
                for(int i=0;i<choise.length;i++){

                    G.drawImage(

                            choise[i].getImage(),
                            choise[i].getPosx(),
                            choise[i].getPosy(),
                            0
                        );
                    if(i==pos){

                        G.drawImage(

                                yesPos,
                                choise[i].getPosx()+2,
                                choise[i].getPosy()+2,
                                0
                            );
                    }else{

                        G.drawImage(

                                noPos,
                                choise[i].getPosx()+2,
                                choise[i].getPosy()+2,
                                0
                            );
                    }
                }
            }

            public final void keyPressed(final int keyCode){ //нажатая кнопка

                switch(keyCode){

                    case GameCanvas.UP:
                        if(pos>0)
                            pos--;

                        break;

                    case GameCanvas.DOWN:
                        if(pos<2)
                            pos++;

                        break;

                    case GameCanvas.FIRE:
                        switch(pos){

                            case 0:
                                LINK.setScreenId((byte)2);
                                break;

                            case 1:
                                LINK.setScreenId((byte)4);
                                break;

                            case 2:
                                CORE.destroyApp(true);
                                break;
                        }
                        break;
                }
            }

            //отпущенная кнопка
            public final void keyReleased(final int keyCode){


            }
        }

        /*
         * Kalter
         * 21:44 02.04.2014
         * (c) Kalter
         * Окно проигрыша
         */

        public final class GameOver extends Screen{

            private final int SCRX,SCRY;
            private final MainCanvas LINK;
            private RImage logo;

            public GameOver(
                    
                    final int SCRX,
                    final int SCRY,
                    final MainCanvas LINK
                ){

                this.LINK=LINK;
                this.SCRX=SCRX;
                this.SCRY=SCRY;
                try{

                    logo=new RImage(

                            Image.createImage("/gameover.png"),
                            (this.SCRX-115)/2,
                            22
                        );
                }catch(final IOException IOE){

                    System.out.println(IOE.getMessage());
                }
                System.out.println("Core.MainCanvas.GameOver loaded");
            }

            public final void paint(final Graphics G){ //перерисовка

                Background.paint(G);
                G.drawImage(logo.getImage(),logo.getPosx(),logo.getPosy(),0);
            }

            public final void keyPressed(final int KEY_CODE){ //нажата кнопка

                switch(KEY_CODE){

                    case GameCanvas.FIRE:
                        LINK.setScreenId((byte)1);
                        break;
                }
            }

            public void keyReleased(final int KEY_CODE){ //отпущена кнопка


            }
        }

        /*
         * Kalter
         * 16:39 16.04.2014
         * (c) Kalter
         * Показывает наивысший рекорд
         */

        public final class HeightScore extends Screen{

            private final int SCRX,SCRY;
            private final MainCanvas LINK;
            private RImage logo;
            private String heightScore;

            public HeightScore(

                    final int SCRX,
                    final int SCRY,
                    final MainCanvas LINK
                ){

                this.SCRX=SCRX;
                this.SCRY=SCRY;
                this.LINK=LINK;
                try{

                    logo=new RImage(

                            Image.createImage("/heightscore.png"),
                            (this.SCRX-124)/2,22
                        );
                }catch(final IOException IOE){

                    System.out.println(IOE.getMessage());
                }
            }

            public final void openHeightScore(){ //получить рекорд

                try{

                    RecordStore recordStore=RecordStore.openRecordStore(

                            "Snake",
                            true
                        );
                    byte data[]=recordStore.getRecord(1);
                    heightScore=""+data[0];
                    data=null;
                    recordStore.closeRecordStore();
                    recordStore=null;
                }catch(final RecordStoreException RSE){

                    System.out.println(RSE.getMessage());
                }
            }

            public final void paint(final Graphics G){ //перерисовка

                Background.paint(G);
                G.drawImage(

                        logo.getImage(),
                        logo.getPosx(),
                        logo.getPosy(),
                        0
                    );
                Font.drawText(G,heightScore,5,96);
            }

            public final void keyPressed(final int KEY_CODE){ //нажата кнопка

                switch(KEY_CODE){

                    case GameCanvas.FIRE:
                        LINK.setScreenId((byte)1);
                        break;
                }
            }

            public final void keyReleased(final int KEY_CODE){ //отпущена кнопка


            }
        }

        /*
         * Kalter
         * 18:17 02.04.2014
         * (c) Kalter
         * Игра
         */

        public final class Game extends Screen{

            private final int SCRX,SCRY;
            private final MainCanvas LINK;
            private final Heart HEART;
            private final Background BACKGROUND;
            private final Gamer GAMER;

            public Game(final int SCRX,final int SCRY,final MainCanvas LINK){

                this.SCRX=SCRX;
                this.SCRY=SCRY;
                this.LINK=LINK;
                HEART=new Heart(this.SCRX,this.SCRY);
                GAMER=new Gamer(this.SCRX,this.SCRY,HEART);
                BACKGROUND=new Background(this.SCRX,this.SCRY);
                System.out.println("Core.MainCanvas.Game loaded");
            }

            public final void newGame(){ //вызывается при начале новой игры

                HEART.newHeart();
                GAMER.newGame();
                System.out.println("New game");
            }

            public final void paint(final Graphics G){ //перерисовка

                BACKGROUND.paint(G);
                HEART.paint(G);
                GAMER.paint(G);
            }

            public final void keyPressed(final int KEY_CODE){ //нажали кнопку

                GAMER.setKeyCode(KEY_CODE);
            }

            //отпустили кнопку
            public final void keyReleased(final int KEY_CODE){


            }

            /*
             * Kalter
             * 19:04 02.04.2014
             * (c) Kalter
             * Игрок
             */

            public final class Gamer implements Runnable{

                private final byte UP=0,DOWN=1,LEFT=2,RIGHT=3;
                private final Vector VECTOR=new Vector();
                private final int SCRX,SCRY;
                private byte move,score;
                private int posx,posy,time,keyCode;
                private boolean gameOverFlag;
                private long lastTime;
                private RSnake rSnake;
                private Thread MOVE;
                private Heart HEART;
                private Image snake;

                //конструктор
                public Gamer(final int SCRX,final int SCRY,final Heart HEART){

                    this.HEART=HEART;
                    this.SCRX=SCRX;
                    this.SCRY=SCRY;
                    try{
                        
                        snake=Image.createImage("/snake.png");
                    }catch(final IOException IOE){
                        
                        System.out.println(IOE.getMessage());
                    }
                    System.out.println("Core.MainCanvas.Game.Gamer loaded");
                }

                //вызывается при начале новой игры
                public final void newGame(){

                    move=RIGHT;
                    posx=32;
                    posy=16;
                    VECTOR.removeAllElements();
                    VECTOR.addElement(new RSnake(posx,posy,RIGHT));
                    VECTOR.addElement(new RSnake(16,16,RIGHT));
                    VECTOR.addElement(new RSnake(0,16,RIGHT));
                    time=500;
                    lastTime=System.currentTimeMillis();
                    score=0;
                    gameOverFlag=false;
                    MOVE=new Thread(this);
                    MOVE.start();
                }

                public final void gameOver(){ //сохранение и уничтожение

                    try{

                        RecordStore recordStore=RecordStore.openRecordStore(

                                "Snake",
                                true
                            );
                        byte data[]=new byte[1];
                        data[0]=(byte)score;
                        byte data2[]=recordStore.getRecord(1);
                        if(data[0]>data2[0])
                            recordStore.setRecord(1,data,0,1);
                        recordStore.closeRecordStore();
                        data=data2=null;
                        recordStore=null;
                    }catch(final RecordStoreException RSE){

                        System.out.println(RSE.getMessage());
                    }
                }

                public final void paint(final Graphics G){ //перерисовка

                    G.setColor(0x61A56E);
                    G.fillRect(0,0,SCRX,16);
                    Font.drawText(G,""+score,2,2);
                    for(byte i=0;i<VECTOR.size();i++){

                        rSnake=(RSnake)VECTOR.elementAt(i);
                        G.drawImage(snake,rSnake.getPosx(),rSnake.getPosy(),0);
                    }
                }

                public final void run(){ //движение

                    while(!gameOverFlag){

                        switch(move){

                            case UP:
                                posy-=16;
                                break;

                            case DOWN:
                                posy+=16;
                                break;

                            case LEFT:
                                posx-=16;
                                break;

                            case RIGHT:
                                posx+=16;
                                break;
                        }
                        VECTOR.insertElementAt(new RSnake(posx,posy,move),0);
                        VECTOR.removeElementAt(VECTOR.size()-1);
                        collision();
                        try{

                            MOVE.sleep(time);
                        }catch(final InterruptedException IE){

                            System.out.println(IE.getMessage());
                        }
                    }
                }

                //записать нажатую кнопку
                public final void setKeyCode(final int KEY_CODE){

                    keyCode=KEY_CODE;
                    if(System.currentTimeMillis()-lastTime>time){

                        lastTime=System.currentTimeMillis();
                        switch(keyCode){

                            case GameCanvas.DOWN:
                                if(move!=UP)
                                    move=DOWN;

                                break;

                            case GameCanvas.UP:
                                if(move!=DOWN)
                                    move=UP;

                                break;

                            case GameCanvas.RIGHT:
                                if(move!=LEFT)
                                    move=RIGHT;

                                break;

                            case GameCanvas.LEFT:
                                if(move!=RIGHT)
                                    move=LEFT;

                                break;
                        }
                    }
                }

                private final void collision(){

                    if((posx==HEART.getPosx())&(posy==HEART.getPosy())){

                        HEART.newHeart();
                        rSnake=(RSnake)VECTOR.lastElement();
                        time-=10;
                        score++;
                        switch(move){

                            case UP:
                                VECTOR.addElement(

                                        new RSnake(

                                         rSnake.getPosx(),
                                         rSnake.getPosy()+16,
                                         move
                                     )
                                    );
                                break;

                            case DOWN:
                                VECTOR.addElement(
                                        
                                        new RSnake(

                                         rSnake.getPosx(),
                                         rSnake.getPosy()-16,
                                         move
                                     )
                                    );
                                break;

                            case LEFT:
                                VECTOR.addElement(
                                        
                                        new RSnake(

                                         rSnake.getPosx()+16,
                                         rSnake.getPosy(),
                                         move
                                     )
                                    );
                                break;

                            case RIGHT:
                                VECTOR.addElement(
                                        
                                        new RSnake(

                                         rSnake.getPosx()-16,
                                         rSnake.getPosy(),
                                         move
                                     )
                                    );
                                break;
                        }
                    }
                    if((posx<0)|(posx+16>SCRX)|(posy<16)|(posy+16>SCRY))
                        gameOverFlag=true;

                    for(byte i=4;i<VECTOR.size();i++){

                        rSnake=(RSnake)VECTOR.elementAt(i);
                        if((posx==rSnake.getPosx())&(posy==rSnake.getPosy())){

                            gameOverFlag=true;
                            break;
                        }
                    }
                    if(gameOverFlag){

                        gameOver();
                        LINK.setScreenId((byte)3);
                    }
                }

                /*
                 * Kalter
                 * 19:29 02.04.2014
                 * (c) Kalter
                 * Для хранения каждого элемента змейки
                 */

                private final class RSnake{

                    private final int POSX,POSY;
                    private final byte MOVE;

                    public RSnake(
                            
                            final int POSX,
                            final int POSY,
                            final byte MOVE
                        ){

                        this.POSX=POSX;
                        this.POSY=POSY;
                        this.MOVE=MOVE;
                        System.out.println(
                                
                                "Core.MainCanvas.Game.Gamer.RSnake loaded"
                            );
                    }

                    public final int getPosx(){ //получить координату х

                        return POSX;
                    }

                    public final int getPosy(){ //получить координату у

                        return POSY;
                    }

                    public final byte getMove(){ //получить направление

                        return MOVE;
                    }
                }
            }

            /*
             * Kalter
             * 19:07 02.04.2014
             * (c) Kalter
             * Сердце
             */

            private final class Heart{

                private final int SCRX,SCRY;
                private final Random RND=new Random();
                private int posy,posx;
                private Image life;

                public Heart(final int SCRX,final int SCRY){

                    this.SCRX=SCRX;
                    this.SCRY=SCRY;
                    try{

                        life=Image.createImage("/life.png");
                    }catch(final IOException IOE){

                        System.out.println(IOE.getMessage());
                    }
                    System.out.println("Core.MainCanvas.Game.Heart loaded");
                }

                public final void paint(final Graphics G){ //перерисовка

                    G.setColor(0x000000);
                    G.drawImage(life,posx,posy,0);
                }

                //получить новые координаты для сердца
                public final void newHeart(){

                    posx=Math.abs(RND.nextInt(SCRX/16))*16;
                    posy=Math.abs(RND.nextInt((SCRY-16)/16))*16+16;
                }

                public final int getPosx(){ //получить координату х

                    return posx;
                }

                public final int getPosy(){ //получить координату у

                    return posy;
                }
            }

            /*
             * Kalter
             * 19:17 02.04.2014
             * (c) Kalter
             * Фон
             */

            private final class Background{

                private final int SCRX,SCRY;
                private Image background;

                public Background(final int SCRX,int SCRY){

                    this.SCRX=SCRX;
                    this.SCRY=SCRY;
                    Image bg=Image.createImage(this.SCRX,this.SCRY),block=null;
                    try{

                        block=Image.createImage("/background.png");
                    }catch(final IOException IOE){

                        System.out.println(IOE.getMessage());
                    }
                    Graphics g=bg.getGraphics();
                    int x=0,y=0;
                    while(y<this.SCRY){

                        g.drawImage(block,x,y,0);
                        x+=16;
                        if(x>this.SCRX){

                            x=0;
                            y+=16;
                        }
                    }
                    background=Image.createImage(this.SCRX,this.SCRY-16);
                    g=background.getGraphics();
                    g.drawImage(bg,0,0,0);
                    bg=block=null;
                    g=null;
                    System.out.println(
                            
                            "Core.MainCanvas.Game.Background loaded"
                        );
                }

                public void paint(final Graphics G){ //перерисовка

                    G.drawImage(background,0,16,0);
                }
            }
        }
    }

    /*
     * Kalter
     * 22:37 17.04.2014
     * (c) Kalter
     * Хранилище картинок
     */

     private final class RImage{

        private final int POSX;
        private final int POSY;
        private final Image IMG;

        public RImage(final Image IMG,final int POSX,final int POSY){

            this.IMG=IMG;
            this.POSY=POSY;
            this.POSX=POSX;
            System.out.println("Core.RImage loaded");
        }

        public final Image getImage(){ //получить картинку

            return IMG;
        }

        public final int getPosx(){ //получить координату х

            return POSX;
        }

        public final int getPosy(){ //получить координату у

            return POSY;
        }
    }

    /*
     * Kalter
     * 19:25 02.04.2014
     * (c) Kalter
     * Фон для всяких менюшек
     */

    private static final class Background{

        private static int scrx,scry;
        private static Image background;

        //конструктор
        public static final void init(final int SCRX,final int SCRY){

            Background.scrx=SCRX;
            Background.scry=SCRY;
            try{

                Image

                        bg=Image.createImage("/menubackground.png"),
                        backg=Image.createImage(

                                           Background.scrx,Background.scry
                                       );
                Graphics g=backg.getGraphics();
                int x=0;
                int y=0;
                while(y<Background.scry){

                    g.drawImage(bg,x,y,0);
                    x+=16;
                    if(x>Background.scrx){

                        x=0;
                        y+=16;
                    }
                }
                bg=Image.createImage("/background.png");
                x=0;
                while(x<Background.scrx){

                    g.drawImage(bg,x,0,0);
                    g.drawImage(bg,x,Background.scry-16,0);
                    x+=16;
                }
                bg=null;
                Background.background=backg;
            }catch(final IOException IOE){

                System.out.println(IOE.getMessage());
            }
            System.out.println(

                    "Core.Background loaded"
                );
        }

        public static final void paint(final Graphics G){ //перерисовка

            G.drawImage(background,0,0,0);
        }
    }

    /*
     * Kalter
     * 17:06 19.04.2014
     * (c) Kalter
     * Рисованные циферки
     */

    public static final class Font{

        private static Image font[]=new Image[10];

        public static final void init(){ //конструктор

            try{

                for(byte i=0;i<font.length;i++)
                    font[i]=Image.createImage("/"+i+".png");
            }catch(final IOException IOE){

                System.out.println(IOE.getMessage());
            }
            System.out.println("Core.Font loaded");
        }

        //вывести num текст в posx posy координатах
        public static final void drawText(

                final Graphics G,
                final String TEXT,
                final int POSX,
                final int POSY
            ){

            for(int i=0;i<TEXT.length();i++){

                int num=TEXT.charAt(i);
                int n=0;
                switch(num){

                    case '0':
                        n=0;

                    case '1':
                        n=1;
                        break;

                    case '2':
                        n=2;
                        break;

                    case '3':
                        n=3;
                        break;

                    case '4':
                        n=4;
                        break;

                    case '5':
                        n=5;
                        break;

                    case '6':
                        n=6;
                        break;

                    case '7':
                        n=7;
                        break;

                    case '8':
                        n=8;
                        break;

                    case '9':
                        n=9;
                        break;
                }
                G.drawImage(font[n],POSX+i*7,POSY,0);
            }
        }
    }
}