/*
 * Decompiled with CFR 0.152.
 */
package CP.Windows;

import CP.Canvas.Canvas;
import CP.Keyboard.Keyboard;
import CP.Math.Math;
import CP.Widgets.Widgets;
import CP.Widgets.Widgets_Widget;
import CP.Windows.Proc$Lit$1;
import CP.Windows.Proc$Lit$2;
import CP.Windows.Proc$Lit$3;
import CP.Windows.Proc$Lit$4;
import CP.Windows.Windows_$T15117;
import CP.Windows.Windows_$T15143;
import CP.Windows.Windows_BoolProc;
import CP.Windows.Windows_Procedure;
import CP.Windows.Windows_Window;

public final class Windows {
    static Windows_Window[] stack;
    static int ptr;
    static int current;

    static {
        int n;
        Windows_Window[] windows_WindowArray = new Windows_Window[16];
        int n2 = 16;
        do {
            n = n2 - 1;
            windows_WindowArray = windows_WindowArray;
            windows_WindowArray[n] = new Windows_Window();
            n2 = n;
        } while (n != 0);
        stack = windows_WindowArray;
    }

    static void Reset(int n) {
        Windows.stack[n].loop = null;
        Windows.stack[n].grabkbd = null;
        Windows.stack[n].data = null;
        Windows.stack[n].x = 0;
        Windows.stack[n].y = 0;
        Windows.stack[n].w = 0;
        Windows.stack[n].h = 0;
        Windows.stack[n].focus = -1;
        Windows.stack[n].list = null;
        Windows.stack[n].ptr = 0;
    }

    public static void Begin(Windows_Procedure windows_Procedure, Windows_BoolProc windows_BoolProc, Object object) {
        Windows.Reset(ptr);
        Windows.stack[Windows.ptr].loop = windows_Procedure;
        Windows.stack[Windows.ptr].grabkbd = windows_BoolProc;
        Windows.stack[Windows.ptr].data = object;
        Windows.stack[Windows.ptr].ptr = current;
        current = ptr++;
    }

    public static void End() {
        current = Windows.stack[Windows.ptr].ptr;
    }

    public static void Close() {
        Windows.Reset(--ptr);
    }

    public static int X() {
        return Windows.stack[Windows.current].x;
    }

    public static int Y() {
        return Windows.stack[Windows.current].y;
    }

    public static void SetXY(int n, int n2) {
        Windows.stack[Windows.current].x = n;
        Windows.stack[Windows.current].y = n2;
    }

    public static int W() {
        return Windows.stack[Windows.current].w;
    }

    public static int H() {
        return Windows.stack[Windows.current].h;
    }

    public static void SetWH(int n, int n2) {
        Windows.stack[Windows.current].w = n;
        Windows.stack[Windows.current].h = n2;
    }

    public static void AlignUp() {
        Windows.stack[Windows.current].y = 0;
    }

    public static void AlignDown() {
        Windows.stack[Windows.current].y = Canvas.Height() - Windows.stack[Windows.current].h;
    }

    public static void AlignLeft() {
        Windows.stack[Windows.current].x = 0;
    }

    public static void AlignRight() {
        Windows.stack[Windows.current].x = Canvas.Width() - Windows.stack[Windows.current].w;
    }

    public static void AlignCenterX() {
        Windows.stack[Windows.current].x = (Canvas.Width() >> 1) - (Windows.stack[Windows.current].w >> 1);
    }

    public static void AlignCenterY() {
        Windows.stack[Windows.current].y = (Canvas.Height() >> 1) - (Windows.stack[Windows.current].h >> 1);
    }

    public static void AlignCenter() {
        Windows.AlignCenterX();
        Windows.AlignCenterY();
    }

    public static void ResetWidgets(int n) {
        int n2;
        Windows_Window windows_Window = stack[current];
        Windows_$T15117[] windows_$T15117Array = new Windows_$T15117[n];
        Windows_$T15117[] windows_$T15117Array2 = windows_$T15117Array;
        int n3 = windows_$T15117Array.length;
        do {
            n2 = n3 - 1;
            windows_$T15117Array2 = windows_$T15117Array2;
            windows_$T15117Array2[n2] = new Windows_$T15117();
            n3 = n2;
        } while (n2 != 0);
        windows_Window.list = windows_$T15117Array2;
    }

    public static void SetWidget(Widgets_Widget widgets_Widget, int n) {
        Windows.stack[Windows.current].list[n].widget = widgets_Widget;
    }

    public static Widgets_Widget GetWidget(int n) {
        if (Windows.stack[Windows.current].list == null) {
            return null;
        }
        if (n < 0 || n > Windows.stack[Windows.current].list.length) {
            return null;
        }
        return Windows.stack[Windows.current].list[n].widget;
    }

    public static void SetFocus(int n) {
        Windows.stack[Windows.current].focus = n;
    }

    static int LenW2W(Widgets_Widget widgets_Widget, Widgets_Widget widgets_Widget2) {
        return Math.SQRT(Math.POW(widgets_Widget.x - widgets_Widget2.x, 2) + Math.POW(widgets_Widget.y - widgets_Widget2.y, 2));
    }

    static int FindNearestWidget(Windows_$T15143 windows_$T15143, Windows_$T15117[] windows_$T15117Array, int n) {
        Widgets_Widget widgets_Widget = null;
        Widgets_Widget widgets_Widget2 = null;
        Widgets_Widget widgets_Widget3 = null;
        if (n >= 0 && n < windows_$T15117Array.length) {
            widgets_Widget = windows_$T15117Array[n].widget;
        }
        if (widgets_Widget == null) {
            return -1;
        }
        int n2 = -1;
        int n3 = windows_$T15117Array.length - 1;
        int n4 = 0;
        if (n3 >= 0) {
            do {
                if ((widgets_Widget2 = windows_$T15117Array[n4].widget) == null || !widgets_Widget2.active) continue;
                if (n2 == -1 && windows_$T15143.Invoke(widgets_Widget2, widgets_Widget)) {
                    n2 = n4;
                    widgets_Widget3 = windows_$T15117Array[n2].widget;
                }
                if (widgets_Widget3 == null || !windows_$T15143.Invoke(widgets_Widget2, widgets_Widget) || Windows.LenW2W(widgets_Widget2, widgets_Widget) >= Windows.LenW2W(widgets_Widget3, widgets_Widget)) continue;
                n2 = n4;
                widgets_Widget3 = windows_$T15117Array[n2].widget;
            } while (n3 >= ++n4);
        }
        return n2;
    }

    static boolean CondUp(Widgets_Widget widgets_Widget, Widgets_Widget widgets_Widget2) {
        return widgets_Widget.y < widgets_Widget2.y;
    }

    public static void CursorUp() {
        int n = Windows.FindNearestWidget(new Proc$Lit$1(), Windows.stack[Windows.current].list, Windows.stack[Windows.current].focus);
        if (n != -1) {
            Windows.stack[Windows.current].focus = n;
        }
    }

    static boolean CondDown(Widgets_Widget widgets_Widget, Widgets_Widget widgets_Widget2) {
        return widgets_Widget.y > widgets_Widget2.y;
    }

    public static void CursorDown() {
        int n = Windows.FindNearestWidget(new Proc$Lit$2(), Windows.stack[Windows.current].list, Windows.stack[Windows.current].focus);
        if (n != -1) {
            Windows.stack[Windows.current].focus = n;
        }
    }

    static boolean CondLeft(Widgets_Widget widgets_Widget, Widgets_Widget widgets_Widget2) {
        return widgets_Widget.x < widgets_Widget2.x;
    }

    public static void CursorLeft() {
        int n = Windows.FindNearestWidget(new Proc$Lit$3(), Windows.stack[Windows.current].list, Windows.stack[Windows.current].focus);
        if (n != -1) {
            Windows.stack[Windows.current].focus = n;
        }
    }

    static boolean CondRight(Widgets_Widget widgets_Widget, Widgets_Widget widgets_Widget2) {
        return widgets_Widget.x > widgets_Widget2.x;
    }

    public static void CursorRight() {
        int n = Windows.FindNearestWidget(new Proc$Lit$4(), Windows.stack[Windows.current].list, Windows.stack[Windows.current].focus);
        if (n != -1) {
            Windows.stack[Windows.current].focus = n;
        }
    }

    static boolean WidgetGrabKeyboard(int n) {
        int n2 = Windows.stack[n].focus;
        if (Windows.stack[n].list == null) {
            return false;
        }
        if (n2 < 0 || n2 > Windows.stack[n].list.length) {
            return false;
        }
        return Widgets.GrabKeyboard(Windows.stack[n].list[n2].widget);
    }

    static boolean WindowGrabKeyboard(int n) {
        return Windows.stack[n].grabkbd != null && Windows.stack[n].grabkbd.Invoke();
    }

    static void HandleInput() {
        int n = current;
        int n2 = 0;
        current = ptr - 1;
        if (0 <= current) {
            do {
                if (!Windows.WidgetGrabKeyboard(current) && !Windows.WindowGrabKeyboard(current)) continue;
                return;
            } while (n2 <= (current += -1));
        }
        current = n;
    }

    static void WindowLoop() {
        if (Windows.stack[Windows.current].loop != null) {
            Windows.stack[Windows.current].loop.Invoke();
        }
    }

    static void HandleLoop() {
        int n = current;
        current = 0;
        if (current < ptr) {
            do {
                Windows.WindowLoop();
            } while (++current < ptr);
        }
        current = n;
    }

    public static void DrawWidgets() {
        if (Windows.stack[Windows.current].list != null) {
            int n = Windows.stack[Windows.current].list.length - 1;
            int n2 = 0;
            if (n >= 0) {
                do {
                    int n3 = Windows.stack[Windows.current].x;
                    int n4 = Windows.stack[Windows.current].y;
                    int n5 = Windows.stack[Windows.current].focus;
                    Widgets.Draw(Windows.stack[Windows.current].list[n2].widget, n3, n4, n5 == n2);
                } while (n >= ++n2);
            }
        }
    }

    public static void Loop() {
        if (ptr > 0) {
            do {
                Windows.HandleInput();
                Keyboard.Update();
                Windows.HandleLoop();
                Canvas.Repaint();
            } while (ptr > 0);
        }
    }
}

